/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.data.manipulation.impl;

import io.gitlab.jfronny.libjf.data.manipulation.impl.ResourcePackHook;
import io.gitlab.jfronny.libjf.unsafe.asm.AsmConfig;
import io.gitlab.jfronny.libjf.unsafe.asm.patch.Patch;
import io.gitlab.jfronny.libjf.unsafe.asm.patch.PatchUtil;
import io.gitlab.jfronny.libjf.unsafe.asm.patch.modification.MethodModificationPatch;
import io.gitlab.jfronny.libjf.unsafe.asm.patch.targeting.InterfaceImplTargetPatch;
import java.io.IOException;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ResourcePackHookPatch
implements AsmConfig {
    private static final String TARGET_CLASS_INTERMEDIARY = "net.minecraft.class_3262";
    private static final String HOOK_IMPLEMENTATION = Type.getInternalName(ResourcePackHook.class);

    public Set<String> skipClasses() {
        return Set.of(PatchUtil.mapClassName((String)TARGET_CLASS_INTERMEDIARY));
    }

    public Set<Patch> getPatches() {
        return Set.of(new InterfaceImplTargetPatch(TARGET_CLASS_INTERMEDIARY, (Patch)new MethodModificationPatch(TARGET_CLASS_INTERMEDIARY, Set.of(new MethodModificationPatch.MethodDescriptorPatch("method_14410", "([Ljava/lang/String;)Lnet/minecraft/class_7367;", (method, klazz) -> {
            this.hookReturn(method, "hookOpenRoot", "Lnet/minecraft/class_7367;", "[java/lang/String");
            return true;
        }), new MethodModificationPatch.MethodDescriptorPatch("method_14405", "(Lnet/minecraft/class_3264;Lnet/minecraft/class_2960;)Lnet/minecraft/class_7367;", (method, klazz) -> {
            this.hookReturn(method, "hookOpen", "Lnet/minecraft/class_7367;", "net/minecraft/class_3264", "net/minecraft/class_2960");
            return true;
        }), new MethodModificationPatch.MethodDescriptorPatch("method_14408", "(Lnet/minecraft/class_3264;Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/class_3262$class_7664;)V", (method, klazz) -> {
            InsnList head = PatchUtil.buildParamPassingInvoker((String)TARGET_CLASS_INTERMEDIARY, (String)HOOK_IMPLEMENTATION, (String)"hookFindResources", null, (String)"Lnet/minecraft/class_3262$class_7664;", (String[])new String[]{"net/minecraft/class_3264", "java/lang/String", "java/lang/String", "net/minecraft/class_3262$class_7664"});
            head.add((AbstractInsnNode)new VarInsnNode(58, 4));
            method.instructions.insert(head);
            return true;
        }), new MethodModificationPatch.MethodDescriptorPatch("method_14407", "(Lnet/minecraft/class_7677;)Ljava/lang/Object;", (method, klazz) -> {
            this.hookReturn(method, "hookParseMetadata", "Ljava/lang/Object;", "net/minecraft/class_7677");
            PatchUtil.redirectExceptions((MethodNode)method, (String)TARGET_CLASS_INTERMEDIARY, (String)HOOK_IMPLEMENTATION, (String)Type.getInternalName(IOException.class), (String)Type.getInternalName(Object.class), (String)"hookParseMetadataEx", (String[])new String[]{"net/minecraft/class_7677"});
            return true;
        })))));
    }

    private void hookReturn(MethodNode method, String targetMethod, String targetType, String ... extraParamTypes) {
        PatchUtil.redirectReturn((MethodNode)method, (String)TARGET_CLASS_INTERMEDIARY, (String)HOOK_IMPLEMENTATION, (String)targetMethod, (String)targetType, (String[])extraParamTypes);
    }
}

